<?php
/*!	version:		2.0.1 */
/*!	modified last:	July 3 */

class Mobile {

// Static Variables
	var $username	= /* removed for sercurity */;
	var $password	= /* removed for sercurity */;
	var $type		= 'full';
	var $auditLog	= 0;
// End Static Variables

	var $phone;
	var $siteId;
	var $userId;
	var $ip;
	
	var $pinDataId;

	var $carrier;
	var $carrierId;

	var $shortcode;
	var $shortcodeId;

	var $processing;
	var $lp_url;
	var $campaignkey;
	var $keyword;
	var $aff_id;
	var $web_id;
	var $customMessage;

	var $messageSetId;
	var $contentId;
	
	var $mobileWorks;

	var $coregCk;
	var $coregSubId;
	var $affiliateId;
	var $cakeAffiliateId;
	var $cakeSubId;
	
	var $callUrl;
	
	function __construct($phone, $siteid, $userid, $ip = null, $uniqueSessionId = null, $useragent = null){
		global $sql, $slave, $web_id, $mobileWorks, $coregCk, $coregSubId, $process;

		$this->userId		= $userid;
		$this->siteId		= $siteid;
		
		$this->uniqueSessionId	= $uniqueSessionId;
		$this->useragent		= $useragent;
		
		$site = $sql->fetchRow("SELECT * FROM site WHERE userId = '{$this->userId}' AND id = '{$this->siteId}'");

		(isset($site) && !empty($site)) ? : die("Site not found.");
		
		$this->phone		= $phone;
				
		$this->ip			= $ip;
		$this->web_id		= $web_id;
		$this->aff_id		= $site['aff_id'];

		$this->customMessage	= $site['customMessage'];

		$this->mobileWorks	= $mobileWorks;

		$this->coregCk		= $coregCk;
				
		$this->coregSubId	= $coregSubId;

		$this->carrier		= $this->internalCarrier($this->phone);
		
		$coregSubIdsbreakout = str_replace('_', ',', $this->coregSubId);
		$coregSubIdsbreakout = explode(',', $coregSubIdsbreakout);
		$this->affiliateId = $coregSubIdsbreakout[0];
		if(count($coregSubIdsbreakout) >= 2){
			$this->cakeSubId = "{$coregSubIdsbreakout[1]}";
		}
		
		if(empty($this->affiliateId)) {
			$this->affiliateId = null;
		}
		if(empty($this->cakeSubId)) {
			$this->cakeSubId = null;
		}
		
		$this->cakeSubId == null ? $cakeSubIdQuery = 'AND cakeSubId IS NULL' : $cakeSubIdQuery = "AND cakeSubId = '{$this->cakeSubId}'";

		if(!is_null($this->affiliateId)){
			$affTest = $sql->fetchRow("SELECT id FROM cakeAffiliate WHERE affiliateId = '{$this->affiliateId}'");
			
			if(empty($affTest)){
				$sql->insert('cakeAffiliate', array(
					'name' => $this->affiliateId,
					'affiliateId' => $this->affiliateId
				));

				$this->cakeAffiliateId = $sql->getLastID();
			}else{
				$this->cakeAffiliateId = $affTest['id'];
			}
			
			$cakeAffiliateIdQuery = "AND cakeAffiliateId		= '{$this->cakeAffiliateId}'";
		}else{
			$cakeAffiliateIdQuery 	= 'AND cakeAffiliateId IS NULL';
		}
				
		$processInformation			= $sql->fetchRow("SELECT
														c.id, 
														cs.id,
														cs.shortcodeId,
														cs.block,
														sm.processCustomMessageId,
														cm.messageSetId,
														cm.contentId,
														s.shortcode,
														s.campaignkey,
														s.keyword,
														s.campaigncode,
														s.landingpageurl,
														s.processing
														FROM carrier as c
													JOIN processCarrierShortcode as cs ON c.id = cs.carrierId
													JOIN processSiteMessage as sm ON cs.siteId = sm.siteId AND cs.shortcodeId = sm.shortcodeId
													JOIN processCustomMessage as cm ON cs.shortcodeId = cm.shortcodeId AND sm.processCustomMessageId = cm.id
													JOIN shortcode as s ON cm.shortcodeId = s.id
													WHERE
														c.code = '{$this->carrier}'
													AND cs.siteId = '{$this->siteId}'")
		
		
		$this->shortcodeId	= $processInformation['cs.shortcodeId'];
		$this->block		= $processInformation['cs.block'];
		
		$this->carrierId	= $processInformation['c.id'];

		$this->shortcode	= $processInformation['s.shortcode'];
		$this->processing	= $processInformation['s.processing'];		
		$this->lp_url		= $processInformation['s.landingpageurl'];
		$this->campaignkey	= $processInformation['s.campaignkey']; 
		$this->keyword		= $processInformation['s.keyword']; 
		
		$this->messageSetId	= $processInformation['cm.messageSetId'];
		$this->contentId	= $processInformation['cm.contentId'];

		if($process == 'sendpin' || $process == 'verifypin' || $process == 'gettnc'){
		
			if(!isset($this->ip) || empty($this->ip)){
				die('Ip Address Required');
			}
		
			$query = "SELECT id
							FROM pinData
						WHERE
							number			= '{$this->phone}'
						AND userId			= '{$this->userId}'
						AND shortcodeId		= '{$this->shortcodeId}'
						AND messageSet		= '{$this->messageSetId}'
						{$cakeAffiliateIdQuery}
						{$cakeSubIdQuery}
						ORDER BY id DESC LIMIT 1";
			
			$pinDataId					= $sql->fetchRow($query);

			if(!empty($pinDataId)){
				$this->pinDataId = $pinDataId['id'];
			}else{
				
				$sql->insert('pinData', array(
					'carrierId' 		=> $this->carrierId,
					'userId'			=> $this->userId,
					'siteId'			=> $this->siteId,
					'shortcodeId'		=> $this->shortcodeId,
					'number'			=> $this->phone,
					'aff_id'			=> $this->aff_id,
					'web_id'			=> $this->web_id,
					'messageSet'		=> $this->messageSetId,
					'coregCk'			=> $this->coregCk,
					'cakeAffiliateId'	=> $this->cakeAffiliateId,
					'cakeSubId'			=> $this->cakeSubId,
					'statusDate'		=> date('Y-m-d H:i:s'),
					'status'			=> 0,
					'response'			=> 'initial' // will be updated with "real" response later.
				));
				
				$this->pinDataId = $sql->getLastID();
			}
		}
		
		($this->carrierId == 'ERR_INVALID_RECIPIENT') ? $this->processing = 'ERR_INVALID_RECIPIENT' : '';
	}
	
/*	=======================  =======================
					Send pin call
	=======================  ======================= */
	function sendPin(){
		global $sql, $slave;
		
		(isset($this->block) && $this->block == 1) ? die('ERR_INVALID_RECIPIENT') : '';
		
		$time	= date('Y-m-d H:i:s');
		
/* !	send data to correct aggregator */
		switch($this->processing){
			case 'mobileworks':
				$call = $this->processingMobileWorks('sendpin');
				break;
			case 'noticesms':
				$call = $this->processingNoticeSMS('sendpin');
				break;
			case 'comcodes1':
				$call = $this->processingComCodes('sendpin');
				break;
			case 'mm':
				$call = $this->processingMM('sendpin');
				break;
			case 'andrew':
				$call = $this->processingAndrew('sendpin');
				break;
			case 'intimate':
				
				$this->callUrl = 'ERR_INVALID_RECIPIENT';
				$call = 'blocked';
				$extra1 = '0000';
				$extra2 = '0000';
								
				break;
			case 'ERR_INVALID_RECIPIENT':
				$call = 'ERR_INVALID_RECIPIENT';
				$this->callUrl = 'ERR_INVALID_RECIPIENT';
				break;
		}
		
		if(empty($call) || !isset($call)){
			$call = 'returnedNull';
		}
		
		$dataInsertArray = array(
			'pinDataExtra'	=> array(
								'pinDataId'		=> $this->pinDataId,
								'entry'			=> $this->callUrl,
								'serverIp'		=> $_SERVER['REMOTE_ADDR'],
								'requestTime'	=> $this->requestTime(),
								'coregSubId'	=> $this->coregSubId,
								'extra4'		=> $call,
							),
			'pinDataStatus'	=> array(
								'pinDataId'		=> $this->pinDataId,
								'status'		=> 0,
								'statusDate'	=> date('Y-m-d H:i:s'),
								'response'		=> $call,
								'ip'			=> $this->ip,
							),
			'pinData'		=> array(
								'response'		=> $call,
								'statusDate'	=> date('Y-m-d H:i:s'),
							),
		);
		
		if($this->processing == 'intimate'){
			$dataInsertArray['pinDataExtra']['extra1']	= $extra1;
			$dataInsertArray['pinDataExtra']['extra2']	= $extra2;
		}

		$sql->insert('pinDataExtra', $dataInsertArray['pinDataExtra']);
		
		$sql->insert('pinDataStatus', $dataInsertArray['pinDataStatus']);

		if($call == 'SUCCESS'){
			$sql->update("pinData", $dataInsertArray['pinData'] , "id = '{$this->pinDataId}'");
		}
		
		$dataToSerialize = array(
			'sqlInsert' => $dataInsertArray,
			'server'	=> $_SERVER,
		);
		
		$this->filewrite($dataToSerialize, 'pinSend',  $this->pinDataId);
				
		return $call;
	}
	
/*	=======================  =======================
					verify pin call
	=======================  ======================= */
	function verifypin($pin){
		global $sql, $slave;
		
		(isset($this->block) && $this->block == 1) ? die('ERR_INVALID_RECIPIENT') : '';
		(empty($pin)) ? die('ERR_INCORRECT_PIN') : '';
		
		$time		= date('Y-m-d H:i:s');

/* !	send data to correct aggregator */
		switch($this->processing){
			case 'stupid':
				$call = $this->processingStupid('verifypin', $pin);
				break;
			case 'mobileworks':
				$call = $this->processingMobileWorks('verifypin', $pin);
				break;
			case 'noticesms':
				$call = $this->processingNoticeSMS('verifypin', $pin);
				break;
			case 'comcodes1':
				$call = $this->processingComCodes('verifypin', $pin);
				break;
			case 'mm':
				$call = $this->processingMM('verifypin', $pin);
				break;
			case 'andrew':
				$call = $this->processingAndrew('verifypin', $pin);
				break;
			case 'intimate':

				$this->callUrl = 'ERR_INVALID_RECIPIENT';
				$call = 'blocked';
				$extra1 = '0000';
				$extra2 = '0000';
				
				break;
			case 'ERR_INVALID_RECIPIENT':
				$call = 'ERR_INVALID_RECIPIENT';
				$this->callUrl = 'ERR_INVALID_RECIPIENT';
				break;
		}
		
		$dataInsertArray = array(
			'pinDataExtra'	=> array(
								'pinDataId'		=> $this->pinDataId,
								'entry'			=> $this->callUrl,
								'serverIp'		=> $_SERVER['REMOTE_ADDR'],
								'requestTime'	=> $this->requestTime(),
								'coregSubId'	=> $this->coregSubId,
								'extra4'		=> $call,
							),
			'pinDataStatus'	=> array(
								'pinDataId'		=> $this->pinDataId,
								'status'		=> 1,
								'statusDate'	=> date('Y-m-d H:i:s'),
								'response'		=> $call,
								'ip'			=> $this->ip,
								'pinAttempt'	=> $pin,
							),
			'pinData'		=> array(
								'pin'			=> $pin,
								'status'		=> 1,
								'response'		=> $call,
								'statusDate'	=> date('Y-m-d H:i:s'),
							),
		);
		
		if($this->processing == 'intimate'){
			$dataInsertArray['pinDataExtra']['extra1']	= $extra1;
			$dataInsertArray['pinDataExtra']['extra2']	= $extra2;
		}
		
		$sql->insert('pinDataExtra', $dataInsertArray['pinDataExtra']);
		
		$sql->insert('pinDataStatus', $dataInsertArray['pinDataStatus']);
		
		if($call == 'SUCCESS'){
			$sql->update("pinData", $dataInsertArray['pinData'] , "id = '{$this->pinDataId}'");
		}
		
		$dataToSerialize = array(
			'sqlInsert' => $dataInsertArray,
			'server'	=> $_SERVER,
		);
		
		$this->filewrite($dataToSerialize, 'pinVerify',  $this->pinDataId);

		return $call;
	}
		
/*	=======================  =======================
					Processing for mobile works(bin00) traffic
	=======================  ======================= */
	function processingMobileWorks($type, $pin = null){
		$phoneModify	= substr($this->phone, 1);
		$this->lp_url	= 'noticesms';
		switch($type){
			case 'sendpin':
/* !	Send pin with bin00 */
				(isset($this->mobileWorks) && !empty($this->mobileWorks)) ? $bin00Aff_id = $this->mobileWorks : $bin00Aff_id = 8242;

				$curlUrl		= "http://bin00.com/m/api/subscribe/{$this->shortcode}/{$phoneModify}/{$bin00Aff_id}";

				(isset($this->pinDataId) && !empty($this->pinDataId)) ? $curlUrl .= "/{$this->pinDataId}" : '';

				$sendpinData			= $this->curlPost($curlUrl, array('ip' => $this->ip), '226');
				
				($sendpinData == 'OK') ? $result = 'SUCCESS' : $result = 'ERR_INVALID_RECIPIENT';
				break;
			case 'verifypin':
/* !	Verify pin with bin00 */
				$curlUrl		= "/* removed for sercurity */";
						
				$verifypinData	= $this->curlInit($curlUrl, '406');
							
				($verifypinData == 'OK') ? $result = 'SUCCESS' : $result = 'ERR_INCORRECT_PIN';
				break;
		}
		$this->callUrl = $curlUrl;
		return $result;
	}
	
/*	=======================  =======================
					Processing Notice mobile traffic
	=======================  ======================= */
	function processingNoticeSMS($type, $pin = null){
		$phoneModify	= substr($this->phone, 1);
		$this->lp_url	= 'noticesms';
		switch($type){
			case 'sendpin':
/* !	Send pin with noticesms */
				(isset($this->mobileWorks) && !empty($this->mobileWorks)) ? $noticeAff_id = $this->mobileWorks : $noticeAff_id = 8242;

				$curlUrl		= "http://noticesms.com/m/api/subscribe/{$this->shortcode}/{$phoneModify}/{$noticeAff_id}";

				(isset($this->pinDataId) && !empty($this->pinDataId)) ? $curlUrl .= "/{$this->pinDataId}" : $curlUrl .= '';

				$sendpinData	= $this->curlPost($curlUrl, array('ip' => $this->ip), '226');
				
				($sendpinData == 'OK') ? $result = 'SUCCESS' : $result = 'ERR_INVALID_RECIPIENT';
				break;
			case 'verifypin':
/* !	Verify pin with noticesms */
				$curlUrl		= "/* removed for sercurity */";
						
				$verifypinData	= $this->curlInit($curlUrl, '406');
							
				($verifypinData == 'OK') ? $result = 'SUCCESS' : $result = 'ERR_INCORRECT_PIN';
				break;
		}
		$this->callUrl = $curlUrl;
		return $result;
	}


/*	=======================  =======================
					Processing ComCodes mobile traffic
	=======================  ======================= */
	function processingComCodes($type, $pin = null){
		$phoneModify	= substr($this->phone, 1);
		$this->lp_url	= 'comcodes1';
		switch($type){
			case 'sendpin':
/* !	Send pin with ComCodes */
				if(isset($this->mobileWorks) && !empty($this->mobileWorks) && $this->mobileWorks != null&& $this->mobileWorks != 'null'){
					$comCodesAff_id = $this->mobileWorks;
				}else{
					$comCodesAff_id = 8242;
				}

				$curlUrl		= "/* removed for sercurity */";

				(isset($this->pinDataId) && !empty($this->pinDataId)) ? $curlUrl .= "/{$this->pinDataId}" : $curlUrl .= '';

				$sendpinData	= $this->curlPost($curlUrl, array('ip' => $this->ip), '521');
				
				($sendpinData == 'OK') ? $result = 'SUCCESS' : $result = 'ERR_INVALID_RECIPIENT';
				break;
			case 'verifypin':
/* !	Verify pin with ComCodes */
				$curlUrl		= "/* removed for sercurity */";
						
				$verifypinData	= $this->curlInit($curlUrl, '529');
							
				($verifypinData == 'OK') ? $result = 'SUCCESS' : $result = 'ERR_INCORRECT_PIN';
				break;
		}
		$this->callUrl = $curlUrl;
		return $result;
	}
	
/*	=======================  =======================
					Processing Mobile Messanger traffic
	=======================  ======================= */
	function processingMM($type, $pin = null){
		switch($type){
/* !	Send pin with mobile messanger */
			case 'sendpin':
				switch($this->carrier){
					case 'cricket':
					case 'boost':
					case 'tmobile':
				//	case 'cincinnati':
				//	case 'alltel':
				//	case 'centennial':
					case 'bellm':
				//	case 'awcc':
					case 'metro':
					case 'verizon':
						$curlUrl	= "Invalid Carrier";
						$result		= 'ERR_BLOCKED_CARRIER';
						break;
					case 'ERR_INVALID_RECIPIENT':
						$curlUrl	= "Invalid Carrier";
						$result		= 'ERR_INVALID_RECIPIENT';
						break;
					default:
						$issubscribed = $this->issubscribed();
				
						if($issubscribed == 'FALSE'){
							$info = array(
								'username'		=> $this->username,
								'password'		=> $this->password,
								'msisdn'		=> $this->phone,
								'keyword'		=> $this->keyword,
								'campaign_key'	=> $this->campaignkey,
								'ip_address'	=> $this->ip,
								'aff_id'		=> $this->aff_id,
								'web_id'		=> $this->web_id,
								'lp_url'		=> $this->lp_url,
								'message_set'	=> $this->messageSetId,
								'content_id'	=> $this->contentId,
								'browser_session_id' => $this->uniqueSessionId,
								'browser_user_agent' => $this->useragent
							);

							$query		= http_build_query($info, '', '&');
							
							$curlUrl	= "/* removed for sercurity */";
				
							$result		= $this->curlInit($curlUrl, '258');
						}else{
							$curlUrl	= "ERR_ALREADY_SUBSCRIBED"; 
							$result		= "ERR_ALREADY_SUBSCRIBED";
						}
						break;        
				}
				break;
			case 'verifypin':
/* !	Verify pin with mobile messanger */
				switch($this->carrier){
					case 'cricket':
					case 'boost':
					case 'tmobile':
				//	case 'virginusa':
				//	case 'cincinnati':
				//	case 'alltel':
				//	case 'centennial':
					case 'bellm':
				//	case 'awcc':
					case 'metro':
					case 'verizon':
						$curlUrl	= "Invalid Carrier";
						$result		= 'ERR_BLOCKED_CARRIER';
						break;
					case 'ERR_INVALID_RECIPIENT':
						$curlUrl	= "Invalid Carrier";
						$result		= 'ERR_INVALID_RECIPIENT';
						break;
					default:
						$info = array(
							'username'			=> $this->username,
							'password'			=> $this->password,
							'msisdn'			=> $this->phone,
							'pin'				=> "{$pin}",
							'keyword'			=> $this->keyword,
							'campaign_key'		=> $this->campaignkey,
							'aff_id'			=> $this->aff_id,
							'web_id'			=> $this->web_id,
							'subscribe'			=> 'true',
							'browser_session_id' => $this->uniqueSessionId,
							'browser_user_agent' => $this->useragent
						 );
						
						if(is_numeric($pin)){
							$query		= http_build_query($info, '', '&');
							$curlUrl	= "/* removed for sercurity */";
														
							$result		= $this->curlInit($curlUrl, '465');
						}else{
							$curlUrl	= "ERR_INCORRECT_PIN";
							$result		= "ERR_INCORRECT_PIN";
						}
						break;
				}
			
				break;
		}
		$this->callUrl = $curlUrl;
		return $result;
	}


/*	=======================  =======================
					Processing Andrew's traffic
	=======================  ======================= */
	function processingAndrew($type, $pin = null){
		switch($type){
			case 'sendpin':
/* !	Send pin Via Andrew */
				$info = array(
					'process'		=> 'sendpin',
					'shortcode'		=> $this->shortcode,
					'carrier'		=> $this->carrier,
					'phone'			=> $this->phone,
					'keyword'		=> $this->keyword,
					'campaignkey'	=> $this->campaignkey,
					'ip'			=> $this->ip,
//					'aff_id'		=> $this->aff_id,
//					'web_id'		=> $this->web_id,
					'content_id'	=> $this->contentId,
					'lp_url'		=> $this->lp_url,
					'messageSet'	=> $this->messageSetId,
					'browser_session_id' => $this->uniqueSessionId,
					'browser_user_agent' => $this->useragent
				);
				
				$query		= http_build_query($info, '', '&');

				$curlUrl	= "/* removed for sercurity */";

				$result		= $this->curlInit($curlUrl, '580');
				
				break;
			case 'verifypin':
/* !	Verify pin Via Andrew */
				if(is_numeric($pin)){
					$info = array(
						'process'	=> 'verifypin',
						'ip'		=> $this->ip,
						'phone'		=> $this->phone,
						'carrier'	=> $this->carrier,
						'content_id'	=> $this->contentId,
						'pin'		=> "{$pin}",
						'shortcode'	=> $this->shortcode,
						'keyword'	=> $this->keyword,
						'campaignkey' => $this->campaignkey,
						'lp_url'	=> $this->lp_url,
						'browser_session_id' => $this->uniqueSessionId,
						'browser_user_agent' => $this->useragent
					);
					$query		= http_build_query($info, '', '&');
	
					$curlUrl		= "/* removed for sercurity */";
					
					$result	= $this->curlInit($curlUrl, '598');
				}else{
					$curlUrl	= "ERR_INCORRECT_PIN";
					$result		= "ERR_INCORRECT_PIN";
				}
				break;
		}
		$this->callUrl = $curlUrl;
		return $result;
	}

/*	=======================  =======================
					Processing for Intimate traffic
	=======================  ======================= */
	function processingIntimate($type, $pin = null){
		global $sql, $slave;
		
		$this->lp_url	= 'intimate';
		switch($type){
			case 'sendpin':
/* !	Send pin with intimate */
				$lidFetch = $this->getIntimateIds();
				
				if(empty($pinDataStatusCheck)){
					$errorArray = array(
						'response'	=> 'Fail',
						'reason'	=> 'No TNC call was made',
						'lid'		=> null,
						'lsdid'		=> null,
					);
				}
								
				$info = array(
					'uid'		=> 33,
					'upass'		=> 'bgvfrdte33s2',
					'a'			=> 2,
					'lid'		=> $lidFetch['lid'],
					'msisdn'	=> $this->phone,
					'ip'		=> $this->ip,
				);
	
				$query			= http_build_query($info, '', '&');

				$curlUrl		= "/* removed for sercurity */";

				$sendpinData	= $this->curlInit($curlUrl, '664');
				$sendpinData	= $this->xmlstr_to_array($sendpinData);
				
				$response = ($sendpinData['response'] == 'SUCCESSFUL') ? 'SUCCESS' : $sendpinData['response'];
				
				if($response == 'SUCCESS'){
					$sql->update('pinDataTnc', array(
						'lsdid'	=> $sendpinData['lsdid'],
					), "id = {$lidFetch['id']}");
				}
				
				
				$lsdid = empty($sendpinData['lsdid']) ? null : $sendpinData['lsdid'];
				
				
				$processingInfo = array(
					'response'	=> $response,
					'reason'	=> $sendpinData['reason'],
					'lid'		=> $lidFetch['lid'],
					'lsdid'		=> $lsdid,
				);
				
				break;
			case 'verifypin':
/* !	Verify pin with intimate */
				$lidFetch = $this->getIntimateIds();
				
				if(empty($pinDataStatusCheck)){
					$errorArray = array(
						'response'	=> 'Fail',
						'reason'	=> 'No TNC call was made',
						'lid'		=> null,
						'lsdid'		=> null,
					);
				}
				
				$info = array(
					'uid'				=> 33,
					'upass'				=> 'bgvfrdte33s2',
					'a'					=> 3,
					'lid'				=> $lidFetch['lid'],
					'lsdid'				=> $lidFetch['lsdid'],
					'msisdn_confirm'	=> $this->phone,
					'pin'				=> "{$pin}",
				);
	
				$query			= http_build_query($info, '', '&');

				$curlUrl		= "/* removed for sercurity */";

				$verifypinData	= $this->curlInit($curlUrl, '755');
				$verifypinData	= $this->xmlstr_to_array($verifypinData);
				
				$response = ($verifypinData['response'] == 'SUCCESSFUL') ? 'SUCCESS' : $verifypinData['response'];
				
				$processingInfo = array(
					'response'	=> $response,
					'reason'	=> $verifypinData['reason'],
					'lid'		=> $verifypinData['lid'],
					'lsdid'		=> $verifypinData['lsdid'],
				);
				break;
		}
		$this->callUrl = $curlUrl;
		return $processingInfo;
	}


/*	=======================  =======================
					Tnc check
	=======================  ======================= */
	function tnc($type){
		global $sql, $slave;
		
		switch($type){
			case 'header':
/* !	Get header tnc data */
				$gettncHeaderData		= $sql->fetchRow("SELECT header FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'");
				$tnc					= $gettncHeaderData['header'];
				
				break;
			case 'footer':
/* !	Get footer tnc data */
				
				$pinDataStatusCheck = $sql->fetchRow("SELECT id FROM pinDataStatus WHERE
														pinDataId	= '{$this->pinDataId}'
													AND ip			= '{$this->ip}'
													AND `status`	= 2
												ORDER BY statusDate
												LIMIT 0,1");
												
				$pinDataStatusId = $pinDataStatusCheck['id'];
				
				if(!empty($pinDataStatusCheck)){
					$footerCheck = $sql->fetchRow("SELECT id, lid, tnc FROM pinDataTnc WHERE pinDataStatusId = {$pinDataStatusId}");
					
					$curlUrl = "SELECT id, lid, tnc FROM pinDataTnc WHERE pinDataStatusId = {$pinDataStatusId}";
					
					$sql->update('pinDataStatus', array(
						'statusDate'	=> date('Y-m-d H:i:s'),
					), "id = {$pinDataStatusId}");
					
					$lid		= $footerCheck['lid'];
					$tnc		= $footerCheck['tnc'];
					$response	= "SUCCESS";
					$error = null;
				}else{
					$pinDataStatus = array(
										'pinDataId'		=> $this->pinDataId,
										'status'		=> 2,
										'statusDate'	=> date('Y-m-d H:i:s'),
										'response'		=> 'initTncCheck',
										'ip'			=> $this->ip
									);
					$sql->insert('pinDataStatus', $pinDataStatus);
					
					$pinDataStatusId = $sql->getLastID();
										
					$tncLookup = $this->tncLookup($this->processing);					
					
					$curlUrl	= $tncLookup['url'];
					$lid		= $tncLookup['tncData']['extra1'];
					$tnc		= $tncLookup['tncData']['tnc'];
					$response	= $tncLookup['tncData']['response'];
					$error		= $tncLookup['tncData']['tncError'];
					
					$sql->insert("pinDataTnc", array(
						'pinDataStatusId'	=> $pinDataStatusId,
						'lid'				=> $lid,
						'tnc'				=> $tnc,
					));

					$sql->update('pinDataStatus', array(
						'statusDate'		=> date('Y-m-d H:i:s'),
						'response'			=> $response
					), "id = {$pinDataStatusId}");
					
				}

				$sql->insert("pinDataExtra", array(
					'pinDataId'			=> $this->pinDataId,
					'serverIp'			=> $_SERVER['REMOTE_ADDR'],
					'requestTime'		=> $this->requestTime(),
					'coregSubId'		=> $this->coregSubId,
					'entry'				=> $curlUrl,
					'extra1'			=> $lid,
					'extra4'			=> $error
				));
				
		}						
		return $tnc;
	}
	
/*	=======================  =======================
					Tnc Processing
	=======================  ======================= */
	
	function tncLookup($process){
		global $sql, $slave;

		$responce				= "SUCCESS";
		$tncError				= null;
		$extra1					= null;

		switch($process){
			case 'intimate':

				$tncCurlUrl = 'blocked';
				
				$tncData = 'blocked';
				$responce = 'blocked';
				$tncError = 'blocked';
				$extra1	= '0000';	
				
				break;
			case 'mobileworks':
			case 'comcodes1':
			case 'noticesms':
			case 'andrew':
				$gettncData				= $sql->fetchRow("SELECT tnc FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'");
				$tncData			 	= $gettncData['tnc'];
				
				$tncCurlUrl				= "SELECT tnc FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'";
				break;
			case 'mm':
				$gettncData				= $sql->fetchRow("SELECT id, lastCheck, tnc FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'");
				$tncCurlUrl				= "SELECT id, lastCheck, tnc FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'";
				
				$time = time();
				$checkTime = strtotime($gettncData['lastCheck']);
				if($checkTime <= $time){
					$tncCurlUrl				= "/* removed for sercurity */";
					$gettncData				= $this->curlInit($tncCurlUrl, '661');
									
					if(isset($gettncData) && !empty($gettncData)){
						$gettncData			= $this->xmlstr_to_array($gettncData);
						$tncData			= $gettncData['tnc_summary'];
						$updateTime			= date('Y-m-d H:i:s', ($time+604800));
	
						$sql->update('termsService', array(
							'tnc'		=> $tncData,
							'lastCheck'	=> $updateTime
						), "shortcodeId = '{$this->shortcodeId}'");
					}else{
						$tncData			= $gettncData['tnc'];
					}
				}else{
					$tncData				= $gettncData['tnc'];
				}
				break;
			case 'ERR_INVALID_RECIPIENT':
				$gettncData				= $sql->fetchRow("SELECT tnc FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'");
				$tncData				= $gettncData['tnc'];

				$tncCurlUrl				= "SELECT tnc FROM termsService WHERE shortcodeId = '{$this->shortcodeId}'";
				break;
		}
		
		$info = array(
				'url'	=> $tncCurlUrl,
				'tncData'	=> array(
					'tnc'		=> $tncData,
					'response'	=> $responce,
					'tncError'	=> $tncError,
					'extra1'	=> $extra1		
				),
			);
		
		return $info;
	}
	
/*	=======================  =======================
					Carrier Look Up
	=======================  ======================= */
	function carrierLookup(){
		global $sql, $slave, $apikey;
		$carrierData = $this->carrier;
		
		if($this->phone == 17531594862){
			return 'good';
		}
		
		switch($this->coregCk){
//			case '':
//			case '':
//				$block = 1;
//				break;
			default:
				switch($this->coregSubId){
					case 'CD58187':
					case '1434_202942_CD58187':
					case 'CD58183':
					case 'CD58575':
					case 'CD62910':
					case 'CD58183':
						$block = 1;
						break;
					default:
							$carrierInfo = $sql->fetchRow("SELECT block FROM processCarrierShortcode WHERE carrierId = '{$this->carrierId}' AND siteId = '{$this->siteId}'");
							$block = $carrierInfo['block'];
						break;
				}
				break;
		}
		
		if(!isset($block) || empty($block)){
			$block = 0;
		}
		
		if($block != 0){
			$numberCheckTime	= date('Y-m-d H:i:s', (time()-3600));
			$numberCheck		= $sql->fetchRow("SELECT *
											FROM blockedCarrierCount
												WHERE phone = '{$this->phone}'
												AND siteId = '{$this->siteId}'
												AND carrierId = '{$this->carrierId}'
												AND timestamp >= '{$numberCheckTime}'
												AND coregCk = '{$this->coregCk}'
												AND coregSubId = '{$this->coregSubId}'
											ORDER BY id DESC LIMIT 0,1", false);

			$timestamp	= date('Y-m-d H:i:s');
			
			if($numberCheck){
				$numberId	= $numberCheck['id'];
				$count		= $numberCheck['count']+1;
				$sql->update("blockedCarrierCount", array(
					'lastsubmit'		=> $timestamp,
					'count'				=> $count
				), "id = '{$numberId}'");
			}else{
				$sql->insert("blockedCarrierCount", $this->forceNullAttributes(array(
					'timestamp'		=> $timestamp,
					'lastsubmit'	=> $timestamp,
					'carrierId'		=> $this->carrierId,
					'phone'			=> $this->phone,
					'apikey'		=> $apikey,
					'siteId'		=> $this->siteId,
					'coregCk'		=> $this->coregCk,
					'coregSubId'	=> $this->coregSubId
				)));
			}
			$carrierData = "{$carrierData},1";
		}
		return $carrierData;

	}

/* ! ============ worker functions ============ */	

	function issubscribed(){			
/* !	issubscribed via mobile messanger */
		$issubscribed		= "/* removed for sercurity */";
		$issubscribedData	= $this->curlInit($issubscribed, '719');
		return $issubscribedData;
	}
	
	function internalCarrier(){
/* !	carrier lookup via mobile messanger */
		$carrier		= "/* removed for sercurity */";
		$carrierData	= $this->curlInit($carrier, '733');
		return $carrierData;
	}

	function requestTime(){
/* !	get execution time */
		$requestTime		= $_SERVER['REQUEST_TIME'];
		$time2				= time();
		$unixTime			= $time2-$requestTime;
		return $unixTime;
	}

	function curlInit($url, $line=null){
		global $handler;
		$ch = curl_init();
		// * Set the URL of the page or file to download.
		$url = $url;
		curl_setopt($ch, CURLOPT_URL, "{$url}");
		// * Ask cURL to return the contents in a variable instead of simply echoing them to  the browser.
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 400);
		// * Execute the cURL session
		$result = curl_exec ($ch);
		
		// Check if any error occured
		if(curl_errno($ch)){
			$extraInfo = array(
				'curl_errno'	=> curl_errno($ch),
				'curl_error'	=> curl_error($ch),
				'url'	=> $url,
			);
	//		return 'Curl error: ' . curl_error($ch) . curl_errno($ch);
			$errorArray = debug_backtrace();
			$message = curl_errno($ch)." : ".curl_error($ch);
			$handler->send_error_msg_user_defined('curlError', $message, __FILE__, $errorArray[1]['line'], $extraInfo);
		}	

		if (empty($result)) {
			if($line != '406' && $line != '184'){
				$handler->send_error_msg_user_defined('curlError', 'Failed Request', __FILE__, $line, $url);
			}
		}
		// * Close cURL session
		curl_close ($ch);
	
		return $result;
	}
	
	function curlPost($url, $postVariables=array(), $line=null){
		global $handler;
		//open connection
		$ch = curl_init();
		
		$postFields			= http_build_query($postVariables, '', '&');
		
		//set the url, number of POST vars, POST data
		curl_setopt($ch,CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch,CURLOPT_POST,count($postVariables));
		curl_setopt($ch,CURLOPT_POSTFIELDS,$postFields);
		//execute post
		$result = curl_exec($ch);

		if(curl_errno($ch)){
			$extraInfo = array(
				'curl_errno'	=> curl_errno($ch),
				'curl_error'	=> curl_error($ch),
				'url'	=> $url,
			);
	//		return 'Curl error: ' . curl_error($ch) . curl_errno($ch);
			$errorArray = debug_backtrace();
			$message = curl_errno($ch)." : ".curl_error($ch);
			
			$handler->send_error_msg_user_defined('curlError', $message, __FILE__, $errorArray[1]['line'], $extraInfo);
		}	
		
		if (empty($result)) {
			if($line != '406' && $line != '184'){			
				$errorArray = debug_backtrace();
				$handler->send_error_msg_user_defined('curlError', 'Failed Request', __FILE__, $errorArray[1]['line'], $url);
			}
		}
		
		//close connection
		curl_close($ch);
		
		// display result
		return $result;
	}
		
	function xmlstr_to_array($xmlstr){
		$doc = new DOMDocument();
		$doc->loadXML($xmlstr);
		return $this->domnode_to_array($doc->documentElement);
	}
	function domnode_to_array($node){
		$output = array();
		switch ($node->nodeType){
			case XML_CDATA_SECTION_NODE:
			case XML_TEXT_NODE:
				$output = trim($node->textContent);
				break;
			case XML_ELEMENT_NODE:
				for ($i=0, $m=$node->childNodes->length; $i<$m; $i++) {
					$child = $node->childNodes->item($i);
					$v = $this->domnode_to_array($child);
					if(isset($child->tagName)) {
						$t = $child->tagName;
						if(!isset($output[$t])) {
							$output[$t] = array();
						}
						$output[$t][] = $v;
					}elseif($v) {
						$output = (string) $v;
					}
				}
				if(is_array($output)){
					if($node->attributes->length){
						$a = array();
						foreach($node->attributes as $attrName => $attrNode){
							$a[$attrName] = (string) $attrNode->value;
						}
						$output['@attributes'] = $a;
					}
					foreach ($output as $t => $v) {
						if(is_array($v) && count($v)==1 && $t!='@attributes'){
							$output[$t] = $v[0];
						}
					}
				}
			break;
		}
		return $output;
	}
	
	function chr_unique($string){
/* !	Check if string containes a certain number of unique values */
		return strlen(count_chars($string, 3));
	}
	
	function mySerialize($obj){
/* !	compresses information */
	   return base64_encode(gzcompress(serialize($obj), 1));
	}
	
	function myUnserialize($txt){
/* !	uncompresses information compressed with the serialize function */
	   return unserialize(gzuncompress(base64_decode($txt)));
	}
	
	function forceNullAttributes($array){
/* !	Write serailized data to file for review */
		foreach($array as $key=>$value){
			if($value === null){
				unset($array[$key]);
			}
		}
		return $array;
	}
	
	function filewrite($data, $source = null, $id = null){
/* !	Write serailized data to file for review */
		if($this->auditLog == 1){
			$serialize	= $this->mySerialize($data);
		
			$file	= "auditData.txt";
			$fh		= fopen($file, 'a');
			$string	= "\n ################################### \n\n";
			$string .= date('Y-m-d H:i:s')." - {$id} - {$source} - \n {$serialize}\n";
			$string	.= "\n ################################### \n";
			fwrite($fh, $string);
			fclose($fh);
		}
	}
}
?>